/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

/**
 * \file    irReceiver.c
 *
 */

#include "irReceiver.h"
#include "stdio.h"

/** **************************************************************************
 * \n \brief Routine to get the value of a uart register.
 *
 * This routine get the value of a uart register.This routine takes uart 
 * controller base addresss as a parameter along with that register offset as
 * another parameter and returns the value of the register.
 * 
 *
 * \param   uart		[IN]	uart controller base address
 * \param   reg         [IN]    register offset value
 *  
 * \return
 * \n      returns register value
 * 
 */
UINT32  UART_rget( UART_Handle uart, UINT32 reg )
{
    UINT32 reg_value;
    UINT32 lcr;
    UINT32 preg32     = ( ( UINT32 )uart ) + ( reg & ~( USE_LCR_80 | USE_LCR_BF ) );
    UINT32 set_lcr_80 = ( ( UINT32 )reg ) & USE_LCR_80;
    UINT32 set_lcr_bf = ( ( UINT32 )reg ) & USE_LCR_BF;

    /* Set LCR if needed */
    if ( set_lcr_80 )
    {
        lcr = UART_rget( uart, LCR_OFFSET );
        UART_rset( uart, LCR_OFFSET, 0x80 );
    }
    if ( set_lcr_bf )
    {
        lcr =  UART_rget( uart, LCR_OFFSET );
        UART_rset( uart, LCR_OFFSET, 0xbf );
    }

    /* Get UART register */
    reg_value = *( volatile UINT32* )( preg32 );

    /* Return LCR reg if necessary */
    if ( set_lcr_80 || set_lcr_bf )
       UART_rset( uart, LCR_OFFSET, lcr );

    return reg_value;
}
/** **************************************************************************
 * \n \brief Routine to set the value of a uart register.
 *
 * This routine set the value of a uart register.This routine takes uart 
 * controller base addresss as a parameter along with that register offset as
 * another parameter and the value of the register.
 * 
 *
 * \param   uart		[IN]	uart controller base address
 * \param   reg         [IN]    register offset value
 *  
 * 
 */
void  UART_rset( UART_Handle uart, UINT32 reg, UINT32 reg_value )
{
    UINT32 lcr;
    UINT32 preg32     = ( ( UINT32 )uart ) + ( reg & ~( USE_LCR_80 | USE_LCR_BF ) );
    UINT32 set_lcr_80 = ( ( UINT32 )reg ) & USE_LCR_80;
    UINT32 set_lcr_bf = ( ( UINT32 )reg ) & USE_LCR_BF;

    /* Set LCR if needed */
    if ( set_lcr_80 )
    {
        lcr =  UART_rget( uart, LCR_OFFSET );
        UART_rset( uart, LCR_OFFSET, 0x80 );
    }
    if ( set_lcr_bf )
    {
        lcr =  UART_rget( uart, LCR_OFFSET );
        UART_rset( uart, LCR_OFFSET, 0xbf );
    }

    /* Set UART register */
    *( volatile UINT32* )( preg32 ) = reg_value;

    /* Return LCR reg if necessary */
    if ( set_lcr_80 || set_lcr_bf )
        UART_rset( uart, LCR_OFFSET, lcr );
}
